var address_country, address_state, address_city, address_street;
$(document).ready(function () {
    $(document).on('change', '.price_input_group', function () {
        price_input_group_change();
    });

    $('#btn_create_ads').on('click', function () {
        document.getElementById("image_orders").value = $("#uploaded-ads-image-wrap").sortable("toArray");
        // $('#adsPostForm').remove('uploaded-ads-image-wrap')
        // $('#adsPostForm').remove('images')
        $('#images').val('');

        var validate = validate_comission_shared();
        if (!validate) {
            alert("La comisión debe ser mayor a 0 (cero).")
        } else {
            $('#adsPostForm').submit();
        }
    });

    $('[name="category"]').change(function () {
        category_change($(this));
    });

    $('[name="type"]').change(function () {
        type_change($(this));
    });

    $('[name="country"]').change(function () {
        country_change($(this));
    });

    $('[name="state"]').change(function () {
        state_change($(this));
    });

    $('[name="city"]').change(function () {
        city_change($(this));
    });

    $('[name="address"]').change(function () {
        street_change($(this));
    });

    $('[name=publish_net]').on('click', function () {
        set_commission_shared($('[name=publish_net]:checked').val());
    });

    set_commission_shared($('[name=publish_net]:checked').val());
    upload_image_events();
    initAutocomplete();
    activarDesactivarPublishMeli();
    $('#current_estate, #purpose').on('change', function () {
        activarDesactivarPublishMeli();
    });
});

function activarDesactivarPublishMeli() {
    var current_state = $('#current_estate').val();
    var purpose = $('#purpose').val();
    if (current_state == "sold" || (current_state == "rented" && purpose != "sale") ||
        current_state == "reserved" || current_state == "temporary_rented"
    ) {
        $('#publish_meli_nopublica').prop('checked', true)
        $('input[name=publish_meli]').attr('disabled', true);
    } else {
        $('input[name=publish_meli]').attr('disabled', false);
    }
}

function validate_comission_shared() {
    if ($('[name=publish_net]:checked').val() == 1) {
        if ($('#commission_shared').val() <= 0) {
            return false;
        }
    }

    return true;
}

function set_commission_shared(value) {
    if (value == 0) {
        $('#commission_shared').attr('readonly', true);
    } else if (value == 1) {
        $('#commission_shared').attr('readonly', false);
    }
}

function upload_image_events() {
    $("#images").change(function () {
        upload_image_events_change($(this));
    });

    $('body').on('click', '.imgDeleteBtn', function () {
        upload_image_events_click_delete($(this));
    });
    //
    // $('body').on('click', '.imgFeatureBtn', function () {
    //   upload_image_events_click_feature($(this));
    // });
}

function price_input_group_change() {
    var price = 0;

    var checkedValues = $('.price_input_group input:checked').map(function () {
        return $(this).data('price');
    }).get();

    for (var i = 0; i < checkedValues.length; i++) {
        price += parseInt(checkedValues[i]); //don't forget to add the base
    }

    $('#payable_amount').text(price);
    $('#price_summery').show('slow');
}



function upload_image_events_click_delete(context) {
    //Get confirm from user
    if (!confirm('¿Seguro que desea eliminar esta Imagen?')) {
        return '';
    }

    var current_selector = context;
    var img_id = context.closest('.img-action-wrap').attr('id');
    $.ajax({
        url: delete_media,
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {media_id: img_id},
        success: function (data) {
            if (data.success == 1) {
                current_selector.closest('.creating-ads-img-wrap').hide('slow');
                toastr.success(data.msg, 'Success!', toastr_options);
            }
        }
    });
}

// function upload_image_events_click_feature(context) {
//   var img_id = context.closest('.img-action-wrap').attr('id');
//   var current_selector = context;
//
//   $.ajax({
//     url: feature_media_creating_ads,
//     type: "POST",
//     headers: {
//       'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//     },
//     data: {media_id: img_id},
//     success: function (data) {
//       if (data.success == 1) {
//         $('.imgFeatureBtn').html('<i class="fa fa-star-o"></i>');
//         current_selector.html('<i class="fa fa-star"></i>');
//         toastr.success(data.msg, 'Success!', toastr_options);
//       }
//     }
//   });
// }

function type_change(context) {
    var meli_category = $(context).find('option:selected').attr('data-melicodcategory');
    $('[name=meli_code_category]').val(meli_category);
}

function category_change(context) {
    var category_id = context.val();
    $('#brand_loader').show();

    $.ajax({
        type: 'POST',
        url: get_brand_by_category,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {category_id: category_id},
        success: function (data) {
            generate_option_from_json(data, 'category_to_brand');
        }
    });
}

function country_change(context) {
    var country_id = context.val();
    address_country = context.find(':selected').text();
    if (country_id != "") {
        geocodeAddress(address_country, geocoder, map);
    }
    $('#state_loader').show();
    $.ajax({
        type: 'POST',
        url: get_state_by_country,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {country_id: country_id},
        success: function (data) {
            generate_option_from_json(data, 'country_to_state');
        }
    });
}

function state_change(context) {
    var state_id = context.val();
    address_state = context.find(':selected').text();
    var country_state = address_country + "," + address_state;
    if (state_id != "") {
        geocodeAddress(country_state, geocoder, map);
    }
    $('#city_loader').show();
    $.ajax({
        type: 'POST',
        url: get_city_by_state,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {state_id: state_id},
        success: function (data) {
            generate_option_from_json(data, 'state_to_city');
        }
    });
}

function city_change(context) {
    var city_id = context.val();
    address_city = context.find(':selected').text();
    var country_state_city = address_country + "," + address_state + "," + address_city;
    if (city_id != "") {
        geocodeAddress(country_state_city, geocoder, map);
    }
    $('#neighborhood_loader').show();
    $.ajax({
        type: 'POST',
        url: get_neighborhood_by_city,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {city_id: city_id},
        success: function (data) {
            generate_option_from_json(data, 'city_to_neighborhood');
        }
    });
}

function street_change(context) {
    address_street = context.val();
    var country_state_city_street = address_country + "," + address_state + "," + address_city + "," + address_street;
    if (address_street != "") {
        geocodeAddress(country_state_city_street, geocoder, map);
    }
}

function generate_option_from_json(jsonData, fromLoad) {
    //Load Category Json Data To Brand Select
    if (fromLoad === 'category_to_brand') {
        var option = '';
        if (jsonData.length > 0) {
            option += '<option value="0" selected> Select a Distance </option>';
            for (i in jsonData) {
                option += '<option value="' + jsonData[i].id + '"> ' + jsonData[i].brand_name + ' </option>';
            }
            $('#brand_select').html(option);
            $('#brand_select').select2();
        } else {
            $('#brand_select').html('');
            $('#brand_select').select2();
        }
        $('#brand_loader').hide('slow');
    } else if (fromLoad === 'country_to_state') {
        var option = '';
        if (jsonData.length > 0) {
            option += '<option value="0" selected> Select state </option>';
            for (i in jsonData) {
                option += '<option value="' + jsonData[i].id + '"> ' + jsonData[i].state_name + ' </option>';
            }
            $('#state_select').html(option);
            $('#state_select').select2();
        } else {
            $('#state_select').html('');
            $('#state_select').select2();
        }
        $('#state_loader').hide('slow');

    } else if (fromLoad === 'state_to_city') {
        var option = '';
        if (jsonData.length > 0) {
            option += '<option value="0" selected> Select city </option>';
            for (i in jsonData) {
                option += '<option value="' + jsonData[i].id + '"> ' + jsonData[i].city_name + ' </option>';
            }
            $('#city_select').html(option);
            $('#city_select').select2();
        } else {
            $('#city_select').html('');
            $('#city_select').select2();
        }
        $('#city_loader').hide('slow');
    } else if (fromLoad === 'city_to_neighborhood') {
        var option = '';
        if (jsonData.length > 0) {
            option += '<option value="0" selected> Select neighborhood </option>';
            for (i in jsonData) {
                option += '<option value="' + jsonData[i].id + '"> ' + jsonData[i].neighborhood_name + ' </option>';
            }
            $('#neighborhood_select').html(option);
            $('#neighborhood_select').select2();
        } else {
            $('#neighborhood_select').html('');
            $('#neighborhood_select').select2();
        }
        $('#neighborhood_loader').hide('slow');
    }
}

var map;
var input;
var searchBox;
var markers = [];
var geocoder;

function initAutocomplete() {
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById('dvMap'), {
        center: {lat: parseFloat(latitude_val), lng: parseFloat(longitude_val)},
        zoom: 4,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    });

    // Create the search box and link it to the UI element.
    input = document.getElementById('pac-input');
    searchBox = new google.maps.places.SearchBox(input);
    map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

    // Bias the SearchBox results towards current map's viewport.
    map.addListener('bounds_changed', function () {
        searchBox.setBounds(map.getBounds());
    });

    //Click event for getting lat lng
    google.maps.event.addListener(map, 'click', function (e) {
        $('input#latitude').val(e.latLng.lat());
        $('input#longitude').val(e.latLng.lng());
        addmarker(e.latLng.lat(), e.latLng.lng());
    });

    /*var marker = new google.maps.Marker({
        position: searchBox.getPlaces()[0].geometry.,
        map: map,
        title: 'Hello World!'
    });*/


    // [START region_getplaces]
    // Listen for the event fired when the user selects a prediction and retrieve
    // more details for that place.
    searchBox.addListener('places_changed', function () {
        var places = searchBox.getPlaces();

        if (places.length == 0) {
            return;
        }

        // Clear out the old markers.
        markers.forEach(function (marker) {
            marker.setMap(null);
        });
        markers = [];

        // For each place, get the icon, name and location.
        var bounds = new google.maps.LatLngBounds();
        places.forEach(function (place) {
            var icon = {
                url: place.icon,
                size: new google.maps.Size(71, 71),
                origin: new google.maps.Point(0, 0),
                anchor: new google.maps.Point(17, 34),
                scaledSize: new google.maps.Size(25, 25)
            };

            // Create a marker for each place.
            markers.push(new google.maps.Marker({
                map: map,
                //icon: icon,
                title: place.name,
                //draggable: true,
                position: place.geometry.location
            }));

            if (place.geometry.viewport) {
                // Only geocodes have viewport.
                bounds.union(place.geometry.viewport);
            } else {
                bounds.extend(place.geometry.location);
            }
        });
        map.fitBounds(bounds);
    });
    // [END region_getplaces]
}

function addmarker(lat, long) {
    //var markers = [];
    markers.forEach(function (marker) {
        marker.setMap(null);
    });
    var latilongi = new google.maps.LatLng(lat, long);
    //var marker = new google.maps.Marker({
    markers.push(new google.maps.Marker({
        position: latilongi,
        title: 'new marker',
        //draggable: true,
        map: map
    }));

}

function geocodeAddress(address, geocoder, resultsMap) {
    //document.getElementById('info').innerHTML = address;
    geocoder.geocode({
        'address': address
    }, function (results, status) {
        if (status === google.maps.GeocoderStatus.OK) {
            resultsMap.fitBounds(results[0].geometry.viewport);
            addmarker(results[0].geometry.location.lat(), results[0].geometry.location.lng());
            $('input#latitude').val(results[0].geometry.location.lat());
            $('input#longitude').val(results[0].geometry.location.lng());
        } else {
            //alert('No se encontraron resultados para la ubicación. ERROR: ' + status);
            alert('No se encontraron resultados para la ubicación.');
        }
    });
}
